const WebSocket = require('ws');

const SERVER_URL = 'ws://localhost:33001';
const apiKey = '68064b237bb1e';
const clientUuid = '00FFC56ED7F2-68064b237bb1e';  // Device UUID

const ws = new WebSocket(SERVER_URL);

ws.on('open', () => {
  console.log('Client connected to server');

  const registerMsg = {
    action: 'register',       // changed from 'registeruser' to 'register'
    apikey: apiKey,
    equipment: clientUuid     // use 'equipment' instead of 'uuid'
  };

  ws.send(JSON.stringify(registerMsg));
  console.log('Client sent registration:', registerMsg);
});

ws.on('message', (data) => {
  console.log('Client received raw data:', data.toString());
});

ws.on('close', () => {
  console.log('Client disconnected');
});

ws.on('error', (err) => {
  console.error('Client error:', err);
});
